<?php
/**
 * 2007-2015 PrestaShop.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    henriqueleite
 *  @copyright Copyright (c) MercadoPago [http://www.mercadopago.com]
 *  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 *  International Registered Trademark & Property of MercadoPago
 */

include_once dirname(__FILE__) . '/../../mercadopago.php';
class MercadoPagoDiscountModuleFrontController extends ModuleFrontController
{

    public function initContent()
    {
        parent::initContent();
        $this->displayAjax();
    }

    public function displayAjax()
    {
        if (isset($_REQUEST['acao'])) {
            $cart = Context::getContext()->cart;
            $response = array(
                'status' => 200,
                'valor' => $cart->getOrderTotal(true, Cart::BOTH)
            );
        } else {
            if (isset($_REQUEST['coupon_id']) && $_REQUEST['coupon_id'] != '') {
                $coupon_id = $_REQUEST['coupon_id'];
                $mercadopago = $this->module;
                $response = $mercadopago->validCoupon($coupon_id);
            } else {
                $response = array(
                    'status' => 400,
                    'response' => array(
                        'error' => 'invalid_id',
                        'message' => 'invalid id'
                    )
                );
            }
        }
        header('Content-Type: application/json');
        echo Tools::jsonEncode($response);
        exit();
    }
}
