<?php

/*
 * 2007-2012 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author PrestaShop SA <contact@prestashop.com>
 *  @copyright  2007-2012 PrestaShop SA
 *  @version  Release: $Revision: 7048 $
 *  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

if (!defined('_PS_VERSION_'))
    exit;

class homefeaturedimax extends Module {

    private $_html = '';
    private $_postErrors = array();

    function __construct() {
        $this->name = 'homefeaturedimax';
        $this->tab = 'front_office_features';
        $this->version = '0.9';
        $this->author = 'Informax';
        $this->need_instance = 0;
		
		$this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('Featured Products on the homepage by Imax');
        $this->description = $this->l('Displays Featured Products in the middle of your homepage.');

      /*  if (version_compare(_PS_VERSION_, '1.5.0.0 ', '>=')) {
            $this->versionPS = 15;
            $context = Context::getContext();
            $this->idShop = $context->shop->id;
            $this->idLang = $context->language->id;
        } else {
            global $cookie;
            $this->versionPS = 14;
            $this->idShop = 1;
            $this->idLang = $cookie->id_lang;
        }*/
		global $cookie;
            $this->versionPS = 16;
			$context = Context::getContext();
            $this->idShop = $context->shop->id;
            $this->idLang = $cookie->id_lang;
		$this->crearTablaOrdenacion();
		//die();
    }

    function install() {
        $this->_clearCache('*');
		if (!Configuration::updateValue('HOME_FEATURED_NBR', 8) || !parent::install() || !$this->registerHook('displayHome') || !$this->registerHook('header'))
            return false;
        return true;
    }

    public function getContent() {
        $output = '<h2>' . $this->displayName . '</h2>';
        if (Tools::isSubmit('submitHomeFeatured')) {
            $nbr = (int) (Tools::getValue('nbr'));
            if (!$nbr OR $nbr <= 0 OR ! Validate::isInt($nbr)) {
                $errors[] = $this->l('Invalid number of products');
				}
            else {
                Configuration::updateValue('HOME_FEATURED_NBR', (int) ($nbr));
				}
            if (isset($errors) AND sizeof($errors)) {
                $output .= $this->displayError(implode('<br />', $errors));
				}
            else {
                $output .= $this->displayConfirmation($this->l('Numero de Productos a Mostrar'));
				}
            $tipo = Tools::getValue('tipoImagenes');
            Configuration::updateValue('HOME_FEATURED_IMAX_TIPO', $tipo);

            $cat = Tools::getValue('catToShow');
            $serializeArray = serialize($cat);
            if (!$serializeArray) {
                $errors[] = $this->l('Selecciona alguna categoria');
				}
            else {
                Configuration::updateValue('HOME_FEATURED_IMAX_CAT', $serializeArray);
				}			
			$categoriasOrdenadas = serialize($this->crearTablaOrdenacion());
			Configuration::updateValue('HOME_FEATURED_IMAX_ORDEN_CAT', $categoriasOrdenadas);
            if (isset($errors) AND sizeof($errors)) {
                $output .= $this->displayError(implode('<br />', $errors));
				}
            else {
                $output .= $this->displayConfirmation($this->l('Categorias Actualizadas'));
				}
        }
        return $output . $this->displayForm();
    }

    public function displayForm() {
        $this->context->controller->addJS($this->_path . "js/jquery-ui.js");
        $this->context->controller->addCss($this->_path . "css/jquery-ui.css");
        $category = new Category();
        $selectCategorias = "";
        $cat = $category->getCategories((int) Context::getContext()->language->id);
        $arrayCatActivadasSerializado = Configuration::get('HOME_FEATURED_IMAX_CAT');
        $arrayCatActivadas = unserialize($arrayCatActivadasSerializado);
        $selectCategorias .= '<ul>';
        foreach ($cat as $cat1) {
            foreach ($cat1 as $c) {
//                    if ($c['infos']['id_parent'] == 2){
                if ($c['infos']['id_parent'] > 1) {
                    if (in_array($c['infos']['id_category'], $arrayCatActivadas)) {
                        $checked = " checked='checked' ";
                    } else {
                        $checked = "";
                    }
                    $categoria = new Category((int) $c['infos']['id_category']);
                    $numProducts = $categoria->getProducts($this->idLang, 9999, 9999, null, null, true);
                    if ($numProducts != 0 || $checked == " checked='checked' ") {
                        $selectCategorias .= '<li  id="id_' . $c['infos']['id_category'] . '"><input type="checkbox" id="catToShow" name="catToShow[]" value="' . $c['infos']['id_category'] . '" ' . $checked . '> ' . $c['infos']['name'] . ' Numero de Productos: ' . $numProducts . '</li>';
                    }
                }
            }
        }
        $selectCategorias .= '</ul>';
        $tipoSeleccionado = Configuration::get('HOME_FEATURED_IMAX_TIPO');
		
        $this->context->controller->addCss($this->_path . 'panel.css', 'all');
        $checked = "";
        $selectImagenes = '<select name="tipoImagenes">';
        foreach (ImageTypeCore::getImagesTypes('products') as $tipo) {
            if ($tipoSeleccionado == $tipo['name']) {
                $checked = " selected='selected' ";
            } else {
                $checked = "";
            }


            $selectImagenes .='<option value="' . $tipo['name'] . '" ' . $checked . ' >' . $tipo['name'] . '</option>';
        }
        $selectImagenes .='<select>';
        $output .= ' 
             <style>
                #sortable { list-style-type: none; margin: 0; padding: 0; width: 60%; }
                #sortable li { margin: 0 3px 3px 3px; padding: 0.4em; padding-left: 1.5em; font-size: 1.4em; height: 18px; }
                #sortable li span { position: absolute; margin-left: -1.3em; }

                #sortable li {
                    cursor: move;
                    background-image: url("'. $this->_path .'flechas-verticales.png");
                    background-repeat: no-repeat;
                    background-color: lime;
                    background-position: 99% 2px;
                    background-size: 10px;
                }
            </style>
                    <ul id="menuTab">
				<li id="menuTab1" class="menuTabButton selected">1. ' . $this->l('Configuracion categorias') . '</li>
                                <li id="menuTab2" class="menuTabButton">2. ' . $this->l('Ordena las Categorias') . '</li>
				<li id="menuTab3" class="menuTabButton">3. ' . $this->l('Ayuda') . '</li>
			</ul>
			<div id="tabList">
				<div id="menuTab1Sheet" class="tabItem selected">
                                <form action="' . Tools::safeOutput($_SERVER['REQUEST_URI']) . '" method="post">
                                 <fieldset><legend><img src="' . $this->_path . 'logo.gif" alt="" title="" />' . $this->l('Settings') . '</legend>
                                         <p>' . $this->l('Para mostrar tus productos, en la pagina principal, selecciona la categoria pertinente.') . '</p><br />
                                         <label>' . $this->l('Numero de productos a mostrar') . '</label>
                                         <div class="margin-form">
                                                 <input type="text" size="5" name="nbr" value="' . Tools::safeOutput(Tools::getValue('nbr', (int) (Configuration::get('HOME_FEATURED_NBR')))) . '" />
                                                 <p class="clear">' . $this->l('The number of products displayed on homepage (default: 10).') . '</p>

                                         </div>
                                         </p>
                                         <p>
                                          <label>' . $this->l('Tipo de Imagen a mostar') . '</label>
                                         <div class="margin-form">' .
                $selectImagenes
                . '<p class="clear">' . $this->l('Seleccione el tipo de la imagen el tamaño se configura en Preferencias Imagenes .') . '</p>

                                         </div>
                                         <label>' . $this->l('Seleccione categorias a Mostrar') . '</label>
                                         <div class="margin-form">' .
                $selectCategorias
                . '</div>
                                         <center><input type="submit" name="submitHomeFeatured" value="' . $this->l('Save') . '" class="button" /></center>
                                 </fieldset>
                         </form>
                         </div>
                         <div id="menuTab2Sheet" class="tabItem">' . $this->ordenarCategorias() . '</div>
                         <div id="menuTab3Sheet" class="tabItem">
                        <ul>
                        <li>
                        Visite nuestra pagina <a href="http://www.informax.es"> Informax.es </a>
                        </li>
                        <li>
                        Mas info de nuestros modulos en el 986 484 538
                        </li>
                        <li>
                        Mas info via mail: <a href="mailto:alberto.alvarez@informax.es">Mail</a>
                        </li>
                        <li>
                        <iframe width="560" height="315" src="//www.youtube.com/embed/_a3df5Qe2X0" frameborder="0" allowfullscreen></iframe>
                        </li>
                        </ul>
                         </div>				
			</div>
			<br clear="left" />			
			<style>
				#menuTab { float: left; padding: 0; margin: 0; text-align: left; }
				#menuTab li { text-align: left; float: left; display: inline; padding: 5px; padding-right: 10px; background: #EFEFEF; font-weight: bold; cursor: pointer; border-left: 1px solid #EFEFEF; border-right: 1px solid #EFEFEF; border-top: 1px solid #EFEFEF; }
				#menuTab li.menuTabButton.selected { background: #FFF6D3; border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-top: 1px solid #CCCCCC; }
				#tabList { clear: left; }
				.tabItem { display: none; }
				.tabItem.selected { display: block; background: #FFFFF0; border: 1px solid #CCCCCC; padding: 10px; padding-top: 20px; }
			</style>
			<script>                       
                        $("ul#tabList li:first").addClass("selected");  //Activar primera pestaña                        
				$(".menuTabButton").click(function () {
				  $(".menuTabButton.selected").removeClass("selected");
				  $(this).addClass("selected");
				  $(".tabItem.selected").removeClass("selected");
				  $("#" + this.id + "Sheet").addClass("selected");                                 
				});
                      $(function() {
                      
                                    $( "#sortable" ).sortable({
                                            beforeStop: function( event, ui ) {
												
                                            },
											update: function(event, ui) {
												var idsInOrder = $("#sortable").sortable("toArray");												
												$.post("'.$this->_path.'homefeaturedImaxAjax.php",{"datos" :encodeURI(idsInOrder)},function(respuesta){
													console.log(respuesta);
												});
											}
                                    });                               
                                  $( "#sortable" ).disableSelection();                                  
                            });   
			</script>';
        return $output;
    }

    public function ordenarCategorias() {
		$arrayCatActivadas = $this->crearTablaOrdenacion();
        $html = '<ul id="sortable">';
        foreach ($arrayCatActivadas as $cat) {
            if ($cat) {
                $categoria = new Category((int) $cat);
                $html .= '<li id="' . $cat . '">' . $categoria->name[$this->idLang] . '</li>';
            }
        }
        $selectCategorias .= '</ul>';
        return $html;
    }
	public function compararIds($a,$b) {
		if($a==$b) {
			return true;
		}
		return false;
	}
    public function hookDisplayHeader($params) {
        $this->hookHeader($params);
    }

    public function hookHeader($params) {
        //$this->context->controller->addCss($this->_path . 'homefeaturedImax.css', 'all');
    }

    public function hookDisplayHome($params) {
        $products = array();
        //$this->context->controller->addCss($this->_path . 'homefeaturedImax.css', 'all');
		$arrayOrdenCategorias = Configuration::get('HOME_FEATURED_IMAX_ORDEN_CAT');
        $nameTipo = Configuration::get('HOME_FEATURED_IMAX_TIPO');
		$ordenCategorias = unserialize($arrayOrdenCategorias);				
        foreach ($ordenCategorias as $i) {
            //$category = new Category(Context::getContext()->shop->getCategory(), (int)Context::getContext()->language->id);
			$category = new Category($i, (int)Context::getContext()->language->id);

            $nb = (int) (Configuration::get('HOME_FEATURED_NBR'));
            $temp = $category->getProducts((int)Context::getContext()->language->id, 1, ($nb ? $nb : 10), null, null, false, true, true, ($nb ? $nb : 10));
            //$products[$category->name] = $temp;
            if (!empty($temp)) {
                $links[$category->name] = $category->getLink();
                $products[$category->name] = $temp;
            }
        }
        $this->smarty->assign(array(
            'products' => $products,
            'add_prod_display' => Configuration::get('PS_ATTRIBUTE_CATEGORY_DISPLAY'),
           // 'homeSize' => Image::getSize($nameTipo),
            'enlaces' => $links,
            'name' => $nameTipo
        ));
		
        return $this->display(__FILE__, 'homefeaturedimax.tpl');
    }
	public function crearTablaOrdenacion() {
		$arrayCatActivadasSerializado = Configuration::get('HOME_FEATURED_IMAX_CAT');		
		$categoriasActivas = unserialize($arrayCatActivadasSerializado);		
		$arrayOrdenCategorias = Configuration::get('HOME_FEATURED_IMAX_ORDEN_CAT');
		$ordenCategorias = unserialize($arrayOrdenCategorias);
		if (empty($ordenCategorias)){		
		for ($i=0;$i <= count($categoriasActivas);$i++ ){
		  $ordenCategorias[] = $i;
		}				
		}
		foreach($ordenCategorias AS $indice=>$ordenCategoria) {
			if(!in_array($ordenCategoria,$categoriasActivas)) {
				unset($ordenCategorias[$indice]);
			}
		}
		$arrayTemp = array_diff($categoriasActivas, $ordenCategorias);
		$arrayDefinitivo = array_merge($ordenCategorias,$arrayTemp);
		return $arrayDefinitivo;
	}
}
