<?php

/*
 * ESTRUCTURA DEL ARCHIVO
 * 0- Attribut	
 * 1- Product Name	
 * 2- Size
 * 3- Brand	
 * 4- Type	
 * 5- Parent SKU	
 * 6- SKU	
 * 7- Stock	
 * 8- Price EURO	
 * 9- Retail EURO	
 * 10- Suggested sell EURO	
 * 11- Weight	
 * 12- Description	
 * 13- Photo1	
 * 14- Photo2	
 * 15- Photo3	
 * 16- Gender	
 * 17- EAN13	
 * 18- Parent Type	
 * 19- Photo4	
 * 20- Photo5
 */
require_once 'functions.php';

class SimpleStreamerCategory Extends ImportFunctionsEceelot {

    var $numElementosProcesados = 0;

    function __construct($archivo) {
        parent::__construct();
        if (is_file($archivo)) {
            $this->fh = $this->openCsvFile($archivo);
        }
    }

    function parse() {
        $this->saltarLineas();
        $idiomas = Language::getLanguages();
        while ($datos = fgetcsv($this->fh, '100000', $this->_separadorCampos, $this->_separadorTexto)) {
//            echo "<pre>";
//            print_r($datos);
//            echo "</pre>";
//            die();
            if (!$datos) {
                $this->finalizadoBatch = 0;
                $this->closeCsvFile($this->fh);
                return false;
            }
//            echo count($datos);
//            echo "<pre>";
//            print_r($datos);
//            echo "</pre>";
//            die();
            $categoria = new ImportFunctionsEceelot();
            if (count($datos) != 21) {
                $this->numElementosProcesados++;
                $categoria->updateNumLineas($this->idImport, $this->tipo, $this->l('Error en el archivo'), $this->numElementosProcesados);
                if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($categoria->sufijo . 'CANTIDAD_CATE')) {
                    unset($categoria);
                    unset($datos);
                    $this->finalizadoBatch = 1;
                    $this->closeCsvFile($this->fh);
                    return true;
                }
                continue;
            }
            //$datos = $this->utf8_encode_array($datos);
            $idCategoriaPadre = Configuration::get($this->sufijo . 'CATEGORIA_PADRE');
            $categoriaPadre = New Category($idCategoriaPadre);
            $idShopDefault = $categoriaPadre->id_shop_default;
            $tempCategorias = array();
            $tempCategorias[] = $datos[16];
            $tempCategorias[] = $datos[18];
            if (trim(strtoupper($datos[4])) != trim(strtoupper($datos[18]))) {
                $tempCategorias[] = $datos[4];
            }
            $categoria->categoria = new StdClass();
            $categoria->categoria->id_category = '';
            $sw = 0;
            foreach ($tempCategorias AS $categorias) {
                if ($sw == 0) {
                    $categoria->categoria->id_category .= trim($categorias);
                    $sw = 1;
                } else {
                    $categoria->categoria->id_category .= '>' . trim($categorias);
                }
                $categoria->categoria->id_parent = $idCategoriaPadre;
                $categoria->categoria->id_shop_default = $idShopDefault;
                $categoria->categoria->active = 1;
                $categoria->categoria->is_root_category = 0;
                foreach ($idiomas AS $idioma) {
                    $categoria->categoria->name[$idioma['id_lang']] = $categorias;
                    $categoria->categoria->link_rewrite[$idioma['id_lang']] = $categorias;
                    $categoria->categoria->description[$idioma['id_lang']] = $categorias;
                    $categoria->categoria->meta_title[$idioma['id_lang']] = $categorias;
                    $categoria->categoria->meta_description[$idioma['id_lang']] = $categorias;
                    $categoria->categoria->meta_keywords[$idioma['id_lang']] = $categorias;
                    $idiomaTemp = $idioma['id_lang'];
                }
                $categoria->categoria->imagen = '';
                if($categoria->categoria->name[$idiomaTemp] != '') {
                    $categoria->crearCategoria();
                    $idCategoriaPadre = $categoria->categoria->id_category;
                    if ($idCategoriaPadre === FALSE) {
                        die("se produjo un error");
                        $this->finalizadoBatch = 1;
                        return false;
                    }
                }else {
                    break;
                }
            }
            $this->numElementosProcesados++;
            $categoria->updateNumLineas($this->idImport, $this->tipo, $categoria->categoria->id_category, $this->numElementosProcesados);
            if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($categoria->sufijo . 'CANTIDAD_CATE')) {
                unset($categoria);
                unset($categorias);
                unset($datos);
                $this->finalizadoBatch = 1;
                $this->closeCsvFile($this->fh);
                return true;
            }
            unset($categoria);
            unset($categorias);
            unset($datos);
        }
        if (!$datos) {
            $this->finalizadoBatch = 0;
            $this->closeCsvFile($this->fh);
            return true;
        }
    }

}

class SimpleStreamerManufacturer Extends ImportFunctionsEceelot {

    var $numElementosProcesados = 0;

    function __construct($archivo) {
        parent::__construct();
        if (is_file($archivo)) {
            $this->fh = $this->openCsvFile($archivo);
        }
    }

    function parse() {
        $this->saltarLineas();
        $idCategoriaPadre = Configuration::get($this->sufijo . 'CATEGORIA_PADRE');
        $categoriaPadre = New Category($idCategoriaPadre);
        $idShopDefault = $categoriaPadre->id_shop_default;
        $idiomas = Language::getLanguages();
        while ($datos = fgetcsv($this->fh, '100000', $this->_separadorCampos, $this->_separadorTexto)) {
            if (!$datos) {
                $this->finalizadoBatch = 0;
                $this->closeCsvFile($this->fh);
                return false;
            }
            $fabricante = new ImportFunctionsEceelot();
            if (count($datos) != 21) {
                $this->numElementosProcesados++;
                $fabricante->updateNumLineas($this->idImport, $this->tipo, $this->l('Error en el archivo'), $this->numElementosProcesados);
                if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($fabricante->sufijo . 'CANTIDAD_MANU')) {
                    unset($fabricante);
                    unset($datos);
                    $this->finalizadoBatch = 1;
                    $this->closeCsvFile($this->fh);
                    return true;
                }
                continue;
            }
            $fabricante->manufacturer = new stdClass();
            $fabricante->manufacturer->lang = null;
            $fabricante->manufacturer->id_shop = $idShopDefault;
            $fabricante->manufacturer->id_manufacturer = $datos[3];
            $fabricante->manufacturer->name = $datos[3];
            $fabricante->manufacturer->date_add = '';
            $fabricante->manufacturer->date_upd = '';
            $fabricante->manufacturer->active = 1;
            foreach ($idiomas AS $idioma) {
                $fabricante->manufacturer->short_description[$idioma['id_lang']] = $datos[3];
                $fabricante->manufacturer->description[$idioma['id_lang']] = $datos[3];
                $fabricante->manufacturer->meta_title[$idioma['id_lang']] = $datos[3];
                $fabricante->manufacturer->meta_keywords[$idioma['id_lang']] = $datos[3];
                $fabricante->manufacturer->meta_description[$idioma['id_lang']] = $datos[3];
            }
            $fabricante->manufacturer->imagen = '';
            if ($fabricante->manufacturer->name != '') {
                if (!$fabricante->crearManufacturer()) {
                    die('error 1');
                    unset($fabricante);
                    unset($datos);
                    return false;
                }
            }
            $this->numElementosProcesados++;
            $fabricante->updateNumLineas($this->idImport, $this->tipo, $fabricante->manufacturer->name, $this->numElementosProcesados);
            if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($fabricante->sufijo . 'CANTIDAD_MANU')) {
                unset($fabricante);
                unset($datos);
                $this->finalizadoBatch = 1;
                $this->closeCsvFile($this->fh);
                return true;
            }
            unset($fabricante);
            unset($datos);
        }
        if (!$datos) {
            $this->finalizadoBatch = 0;
            $this->closeCsvFile($this->fh);
            return true;
        }
    }

}

class SimpleStreamerProveedor Extends ImportFunctionsEceelot {

    var $numElementosProcesados = 0;

    function __construct($archivo) {
        parent::__construct();
        if (is_file($archivo)) {
            $this->fh = $this->openCsvFile($archivo);
        }
    }

    function parse() {
        $this->saltarLineas();
        $datos = array();
        while ($datos = fgetcsv($this->fh, '100000', $this->_separadorCampos, $this->_separadorTexto)) {
            if (!$datos) {
                $this->finalizadoBatch = 0;
                $this->closeCsvFile($this->fh);
                return false;
            }
            $proveedor = new ImportFunctionsEceelot();
            $datos = $this->utf8_encode_array($datos);
            $proveedor->supplier->lang = null;
            $proveedor->supplier->id_shop = $datos[28];
            $proveedor->supplier->id_supplier = $datos[23];
            $proveedor->supplier->name = $datos[23];
            $proveedor->supplier->date_add = '';
            $proveedor->supplier->date_upd = '';
            $proveedor->supplier->active = 1;
            $proveedor->supplier->description[Configuration::get('PS_LANG_DEFAULT')] = '';
            $proveedor->supplier->meta_title[Configuration::get('PS_LANG_DEFAULT')] = '';
            $proveedor->supplier->meta_keywords[Configuration::get('PS_LANG_DEFAULT')] = '';
            $proveedor->supplier->meta_description[Configuration::get('PS_LANG_DEFAULT')] = '';
            $proveedor->supplier->imagen = '';
            if ($proveedor->supplier->name != '') {
                if (!$proveedor->crearSupplier()) {
                    die('error 1');
                    unset($proveedor);
                    unset($datos);
                    return false;
                }
            }
            $this->numElementosProcesados++;
            $proveedor->updateNumLineas($this->idImport, $this->tipo, $proveedor->supplier->name, $this->numElementosProcesados);
            if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($proveedor->sufijo . 'CANTIDAD_MANU')) {
                unset($proveedor);
                unset($datos);
                $this->finalizadoBatch = 1;
                $this->closeCsvFile($this->fh);
                return true;
            }
            unset($proveedor);
            unset($datos);
        }
        if (!$datos) {
            $this->finalizadoBatch = 0;
            $this->closeCsvFile($this->fh);
            return true;
        }
    }

}

class SimpleStreamerProduct Extends ImportFunctionsEceelot {

    var $numElementosProcesados = 0;

    function __construct($archivo) {
        parent::__construct();
        $this->archivo = $archivo;
        if (is_file($archivo)) {
            $this->openCsvFile($archivo);
        }
    }

    function parse() {
        $this->saltarLineas();
        $datosTemp = array();
        $idCategoriaPadre = Configuration::get($this->sufijo . 'CATEGORIA_PADRE');
        $categoriaPadre = New Category($idCategoriaPadre);
        $idShopDefault = $categoriaPadre->id_shop_default;
        $idiomas = Language::getLanguages();
        while ($datos = fgetcsv($this->fh, '100000', $this->_separadorCampos, $this->_separadorTexto)) {
            if (!$datos) {
                $this->finalizadoBatch = 0;
                $this->closeCsvFile($this->fh);
                return false;
            }
            $producto = new ImportFunctionsEceelot();
            if (count($datos) != 21) {
                $this->numElementosProcesados++;
                $producto->updateNumLineas($this->idImport, $this->tipo, $this->l('Error en el archivo'), $this->numElementosProcesados);
                if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($producto->sufijo . 'CANTIDAD_PROD')) {
                    unset($producto);
                    unset($datos);
                    $this->finalizadoBatch = 1;
                    $this->closeCsvFile($this->fh);
                    return true;
                }
                echo "Error en el archivo<pre>";
                print_r($datos);
                echo "</pre>";
                die();
                continue;
            }
            if (trim($datos[5]) != '') {
                $this->numElementosProcesados++;
                $producto->updateNumLineas($this->idImport, $this->tipo, $this->l('Producto con atributos: ') . trim($datos[1]), $this->numElementosProcesados);
                if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($producto->sufijo . 'CANTIDAD_PROD')) {
                    unset($producto);
                    unset($datos);
                    $this->finalizadoBatch = 1;
                    $this->closeCsvFile($this->fh);
                    return true;
                }
                continue;
            }

            $producto->producto = new stdClass();
            //$datos = $this->utf8_encode_array($datos);

            $producto->producto->lang = '1';
            $producto->producto->id_shop_default = $idShopDefault;
            $producto->producto->id_product = $datos[6];
            $producto->producto->id_supplier = 0;
            $producto->producto->id_manufacturer = $datos[3];
            $producto->producto->id_tax_rules_group = 0;
            $tempCategorias = array();
            $tempCategorias[] = $datos[16];
            $tempCategorias[] = $datos[18];
            if (trim(strtoupper($datos[4])) != trim(strtoupper($datos[18]))) {
                $tempCategorias[] = $datos[4];
            }
            $sw = 0;
            foreach ($tempCategorias AS $categorias) {
                if ($sw == 0) {
                    $producto->producto->id_category_default .= trim($categorias);
                    $sw = 1;
                } else {
                    $producto->producto->id_category_default .= '>' . trim($categorias);
                }
            }
            //$producto->producto->id_category_default = implode(">", $categoriaTemp);            
            $producto->producto->id_color_default = 0;
            $producto->producto->on_sale = Configuration::get($this->sufijo . 'MARCAR_OFERTA');
            $producto->producto->online_only = '';
            $producto->producto->ean13 = $datos[17];
            $producto->producto->upc = '';
            $producto->producto->ecotax = '';

            $producto->producto->available_date = '';
            $producto->producto->minimal_quantity = 1;
            $tipoPrecio = ConfigurationCore::get($this->sufijo . 'TIPO_PRECIO');
            if ($tipoPrecio == 0) {
                $producto->producto->price = $datos[9];
            } else {
                $producto->producto->price = $datos[10];
            }
            $producto->producto->priceReseller = $datos[9];
            $producto->producto->wholesale_price = $datos[8];
            $producto->producto->unit_price_ratio = 0;
            $producto->producto->additional_shipping_cost = 0;
            $producto->producto->unity = '';
            $producto->producto->reference = (mb_strlen($datos[6]) > 32) ? '' : $datos[6];
            $producto->producto->supplier_reference = (mb_strlen($datos[6]) > 32) ? '' : $datos[6];
            $producto->producto->location = '';
            $producto->producto->width = 0;
            $producto->producto->height = 0;
            $producto->producto->depth = 0;
            $producto->producto->weight = 0;
            $producto->producto->quantity = $datos[7];
            $producto->producto->out_of_stock = $producto->producto->quantity == 0 ? 1 : 0;
            $producto->producto->quantity_discount = 0;
            $producto->producto->customizable = 0;
            $producto->producto->uploadable_files = '';
            $producto->producto->text_fields = '';
            $producto->producto->active = 1;
            $producto->producto->available_for_order = 1;
            $producto->producto->condition = 'new';
            $producto->producto->show_price = 1;
            $producto->producto->cache_default_attribute = 0;
            $producto->producto->date_add = date('d/m/Y H:i:s');
            $producto->producto->date_upd = date('d/m/Y H:i:s');
            $producto->producto->visibility = 'both';

            foreach ($idiomas AS $idioma) {
                $nombre = explode(' - ', $datos[1]);
                if (isset($nombre[0])) {
                    if(count($nombre) > 2) {
                        $temp = array_pop($nombre);
                        $texto = implode('-', $nombre); 
                    }else {
                        $texto = $nombre[0];
                    }            
                    $texto = trim($texto);
                } else {
                    $texto = mb_substr(trim($datos[1]), 0, 31);
                }
                $showPrice = Configuration::get($this->sufijo . 'SHOW_PRICE');
                $resellerPrice = "";
                if ($showPrice == 1){                
                $resellerPrice = '<div class="precioReseller"><span>'.$producto->l('Antes: ').'</span>'.$datos[9].'&euro;</div>';
                }
                $producto->producto->name[$idioma['id_lang']] = trim($texto);
                $producto->producto->description[$idioma['id_lang']] = $resellerPrice.$datos[12];
                $producto->producto->description_short[$idioma['id_lang']] = mb_substr($datos[12], 0, 128) . '...';
                $producto->producto->link_rewrite[$idioma['id_lang']] = trim($texto);;
                $producto->producto->meta_title[$idioma['id_lang']] = trim($texto);;
                $producto->producto->meta_keywords[$idioma['id_lang']] = trim($texto);;
                $producto->producto->meta_description[$idioma['id_lang']] = trim($texto);;                
                $producto->producto->available_now[$idioma['id_lang']] = '';
            }

            $producto->producto->taxValue = '';
            $imagenes = array();
            if (trim($datos[13]) != '') {
                $imagenes[] = trim($datos[13]);
            }
            if (trim($datos[14]) != '') {
                $imagenes[] = trim($datos[14]);
            }
            if (trim($datos[15]) != '') {
                $imagenes[] = trim($datos[15]);
            }
            if (trim($datos[19]) != '') {
                $imagenes[] = trim($datos[19]);
            }
            if (trim($datos[20]) != '') {
                $imagenes[] = trim($datos[20]);
            }
            $cover = 1;
            $position = 1;
            if (!empty($imagenes)) {
                foreach ($imagenes AS $imagen) {
                    $temp = new stdClass();
                    $temp->cover = $cover;
                    $temp->legend = $datos[1];
                    $temp->position = $position;
                    $temp->link = $imagen;
                    $cover = 0;
                    $position++;
                    $producto->producto->imagenes[] = $temp;
                }
            }
            if ($producto->producto->name[Configuration::get('PS_LANG_DEFAULT')] != '') {
                if (!$producto->crearProducto()) {
                    die('error 1');
                    unset($producto);
                    unset($datos);
                    unset($temp);
                    unset($nombre);
                    return false;
                }
            }
            $this->numElementosProcesados++;
            $producto->updateNumLineas($this->idImport, $this->tipo, $texto, $this->numElementosProcesados);
            if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($producto->sufijo . 'CANTIDAD_PROD')) {
                unset($producto);
                unset($datos);
                unset($temp);
                unset($nombre);
                $this->finalizadoBatch = 1;
                $this->closeCsvFile($this->fh);
                return true;
            }
            unset($producto);
            unset($datos);
            unset($temp);
            unset($nombre);
        }
        if (!isset($datos) || !$datos) {
            $this->finalizadoBatch = 0;
            $this->closeCsvFile($this->fh);
            return true;
        }
    }

}

class SimpleStreamerAtributos extends ImportFunctionsEceelot {

    var $numElementosProcesados = 0;

    function __construct($archivo) {
        parent::__construct();
        $this->archivo = $archivo;
        if (is_file($archivo)) {
            $this->openCsvFile($archivo);
        }
    }

    function parse() {
        $this->saltarLineas();
        $idCategoriaPadre = Configuration::get($this->sufijo . 'CATEGORIA_PADRE');
        $categoriaPadre = New Category($idCategoriaPadre);
        $idShopDefault = $categoriaPadre->id_shop_default;
        $idiomas = Language::getLanguages();
        while ($datos = fgetcsv($this->fh, '100000', $this->_separadorCampos, $this->_separadorTexto)) {
            if (!$datos) {
                $this->finalizadoBatch = 0;
                $this->closeCsvFile($this->fh);
                return false;
            }
            $atributo = new ImportFunctionsEceelot();
            if (count($datos) != 21) {
                $this->numElementosProcesados++;
                $atributo->updateNumLineas($this->idImport, $this->tipo, $this->l('Error en el archivo'), $this->numElementosProcesados);
                if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($atributo->sufijo . 'CANTIDAD_ATRIBUTOS')) {
                    unset($atributo);
                    unset($datos);
                    $this->finalizadoBatch = 1;
                    $this->closeCsvFile($this->fh);
                    return true;
                }
                echo "Error en el archivo<pre>";
                print_r($datos);
                echo "</pre>";
                die();
                continue;
            }
            if (trim($datos[5]) == '') {
                $this->numElementosProcesados++;
                $atributo->updateNumLineas($this->idImport, $this->tipo, $this->l('Producto sin atributos: ') . trim($datos[1]), $this->numElementosProcesados);
                if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($atributo->sufijo . 'CANTIDAD_ATRIBUTOS')) {
                    unset($atributo);
                    unset($datos);
                    $this->finalizadoBatch = 1;
                    $this->closeCsvFile($this->fh);
                    return true;
                }
                continue;
            }

            $atributo->atributo = new stdClass();
            $atributo->atributo->lang = null;

            $atributo->atributo->id_attribute_group = 'Talla';
            $atributo->atributo->is_color_group = 0;
            if ($atributo->versionPS >= 15) {
                $atributo->atributo->group_type = 'select';
                $atributo->atributo->position = 1;
            }

            $idIdioma = Configuration::get('PS_LANG_DEFAULT');
            $atributo->atributo->name[$idIdioma] = 'Talla';
            $atributo->atributo->public_name[$idIdioma] = 'Talla';
            $atributo->atributo->atributo = new stdClass();
            $atributo->atributo->atributo->idiomas[$idIdioma] = new stdClass();
            $atributo->atributo->atributo->idiomas[$idIdioma]->name = mb_strtolower($datos[2]);

           
            if ($atributo->atributo->name[Configuration::get('PS_LANG_DEFAULT')] != '') {
                if (!$atributo->crearAtributos()) {
                    die('error 1');
                    unset($atributo);
                    unset($datos);
                    return false;
                } else {
                    if (!$this->procesarProductoAtributos($datos)) {
                        die('error 2');
                        unset($atributo);
                        unset($datos);
                        unset($temp);
                        return false;
                    }
                }
            }
            $nombreProducto = explode('-', $datos[1]);
            $this->numElementosProcesados++;
            $atributo->updateNumLineas($this->idImport, $this->tipo, trim($nombreProducto[0]), $this->numElementosProcesados);
            if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($atributo->sufijo . 'CANTIDAD_ATRIBUTOS')) {
                unset($atributo);
                unset($datos);
                unset($temp);
                $this->finalizadoBatch = 1;
                $this->closeCsvFile($this->fh);
                return true;
            }
            unset($producto);
            unset($datos);
            unset($temp);
        }
        if (!isset($datos) || !$datos) {
            $this->finalizadoBatch = 0;
            $this->closeCsvFile($this->fh);
            return true;
        }
    }

    private function procesarProductoAtributos($datos) {
        $atributosPorProducto = new ImportFunctionsEceelot();
        $atributosPorProducto->producto = new stdClass();
        
        //$atributosPorProducto->producto->id_product = $producto->producto->id_product = $datos[5];
        $atributosPorProducto->producto->id_product =  $datos[5];

        $atributosPorProducto->atributoPorProducto = new stdClass();

        $atributosPorProducto->atributoPorProducto->lang = null;
        $atributosPorProducto->atributoPorProducto->id_product_attribute = $datos[6];
        $atributosPorProducto->atributoPorProducto->id_product = $datos[5];
        $atributosPorProducto->atributoPorProducto->reference = (mb_strlen($datos[6]) > 32) ? '' : $datos[6];
        $atributosPorProducto->atributoPorProducto->supplier_reference = (mb_strlen($datos[6]) > 32) ? '' : $datos[6];
        $atributosPorProducto->atributoPorProducto->location = '';
        $atributosPorProducto->atributoPorProducto->ean13 = $datos[17];
        $atributosPorProducto->atributoPorProducto->upc = '';
        $atributosPorProducto->atributoPorProducto->ecotax = 0;
        $atributosPorProducto->atributoPorProducto->quantity = $datos[7];
        $atributosPorProducto->atributoPorProducto->weight = (float) $datos[11];
        $atributosPorProducto->atributoPorProducto->unit_price_impact = '';
        $atributosPorProducto->atributoPorProducto->default_on = 1;
        $atributosPorProducto->atributoPorProducto->minimal_quantity = 1;
        $atributosPorProducto->atributoPorProducto->atributosPorProducto[] = 'Talla-' . $datos[2];
        $tipoPrecio = ConfigurationCore::get($this->sufijo . 'TIPO_PRECIO');
        if ($tipoPrecio == 0) {
            $atributosPorProducto->atributoPorProducto->price = $datos[9];
        } else {
            $atributosPorProducto->atributoPorProducto->price = $datos[10];
        }
        $atributosPorProducto->atributoPorProducto->wholesale_price = $datos[8];
        $idProducto = $atributosPorProducto->searchEquivalenciaProducto();
        $producto = new Product($idProducto);
        $atributosPorProducto->producto->price = $producto->price;
        $atributosPorProducto->producto->wholesale_price = $producto->wholesale_price;

        $atributosPorProducto->atributoPorProducto->taxValue = 0;

        if ($atributosPorProducto->addAtributoAproducto()) {
            $atributosPorProducto->updateNumLineas($this->idImport, $this->tipo, $datos[6], $this->numElementosProcesados);
            $this->numElementosProcesados++;
            unset($atributosPorProducto);
            unset($datos);
            return true;
        } else {
            unset($atributosPorProducto);
            unset($datos);
            return false;
        }
    }

}

class SimpleStreamerCaracteristicas Extends ImportFunctionsEceelot {

    var $numElementosProcesados = 0;

    function __construct($archivo) {
        parent::__construct();
        if (is_file($archivo)) {
            $this->fh = $this->openCsvFile($archivo);
        }
    }

    function parse() {
        $this->saltarLineas();
        $datos = array();
        $this->numElementosProcesados = 0;
        while ($datos = fgetcsv($this->fh, '100000', $this->_separadorCampos, $this->_separadorTexto)) {
            $caracteristicas = new ImportFunctionsEceelot();
            //echo 'Elementos:' . (int) $this->numElementosProcesados . ' ---- ' . (int) ConfigurationCore::get($caracteristicas->sufijo . 'CANTIDAD_PROCESADA') . '<br />';

            if (!$datos) {
                $this->finalizadoBatch = 0;
                $this->closeCsvFile($this->fh);
                return false;
            }

            $caracteristicaTemp = $datos[6];
            if ($caracteristicaTemp == '' || empty($caracteristicaTemp)) {
                $this->numElementosProcesados++;
                $caracteristicas->updateNumLineas($this->idImport, $this->tipo, '', $this->numElementosProcesados);
                if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($caracteristicas->sufijo . 'CANTIDAD_CARAC')) {
                    unset($caracteristicas);
                    unset($datos);
                    $this->finalizadoBatch = 1;
                    $this->closeCsvFile($this->fh);
                    return true;
                }
                unset($caracteristicas);
                unset($datos);
                unset($caracteristicaTemp);
                continue;
            }
            $caracteristicas->caracteristica = new StdClass();
            $caracteristicas->caracteristica->lang = null;
            $caracteristicas->caracteristica->idProduct = $datos[6];
            $caracteristicas->caracteristica->id_feature = $datos[6];
            $caracteristicas->caracteristica->position = false;
            $caracteristicas->caracteristica->name = 'SKU';
            $caracteristicas->caracteristica->valor = $datos[6];

            if ($caracteristicas->caracteristica->name != '') {
                if (!$caracteristicas->crearCaracteristica()) {
                    die('error 1');
                    unset($caracteristicas);
                    unset($datos);
                    return false;
                }
            }
            $this->numElementosProcesados++;
            $caracteristicas->updateNumLineas($this->idImport, $this->tipo, $caracteristicas->caracteristica->name.':'.$caracteristicas->caracteristica->valor, $this->numElementosProcesados);
            if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($caracteristicas->sufijo . 'CANTIDAD_PROD')) {
                unset($caracteristicas);
                unset($datos);
                $this->finalizadoBatch = 1;
                $this->closeCsvFile($this->fh);
                return true;
            }
            unset($caracteristicas);
            unset($datos);
        }
        if (!$datos) {
            $this->finalizadoBatch = 0;
            $this->closeCsvFile($this->fh);
            return true;
        }
    }

}

class SimpleStreamerIdiomas Extends ImportFunctionsEceelot {

    var $numElementosProcesados = 0;

    function __construct($archivo) {
        parent::__construct();
        $this->archivo = $archivo;
        if (is_file($archivo)) {
            $this->openCsvFile($archivo);
        }
    }

    function parse() {
        $this->saltarLineas();
        $datosTemp = array();
        while ($datosTemp = fgetcsv($this->fh, '100000', $this->_separadorCampos, $this->_separadorTexto)) {
            if (!$datosTemp) {
                $this->finalizadoBatch = 0;
                $this->closeCsvFile($this->fh);
                return false;
            }
            foreach ($datosTemp AS $indice => $valor) {
                $datos[$indice] = str_replace('"', "'", $valor);
            }
            $producto = new ImportFunctionsEceelot();
            $producto->producto = new stdClass();
            if (count($datos) != 21) {
                $this->numElementosProcesados++;
                $producto->updateNumLineas($this->idImport, $this->tipo, $this->l('Error en el archivo'), $this->numElementosProcesados, $this->orden);
                if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($producto->sufijo . 'CANTIDAD_PROD')) {
                    unset($producto);
                    unset($datos);
                    $this->finalizadoBatch = 1;
                    $this->closeCsvFile($this->fh);
                    return true;
                }
                echo "Error en el archivo<pre>";
                print_r($datos);
                echo "</pre>";
                die();
                continue;
            }
            if (trim($datos[5]) != '') {
                $this->numElementosProcesados++;
                $producto->updateNumLineas($this->idImport, $this->tipo, $this->l('Atributo no traducible: ') . trim($datos[1]), $this->numElementosProcesados, $this->orden);
                if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($producto->sufijo . 'CANTIDAD_PROD')) {
                    unset($producto);
                    unset($datos);
                    $this->finalizadoBatch = 1;
                    $this->closeCsvFile($this->fh);
                    return true;
                }
                continue;
            }
            $producto->producto->id_product = $datos[6];
            $idProducto = $producto->searchEquivalenciaProducto();
            if ($idProducto == NULL) {
                $producto->updateNumLineas($this->idImport, $this->tipo, 'Producto no existe: ' . $datos[1], $this->numElementosProcesados, $this->orden);
                echo 'no existe el producto';
                continue;
            }
            $producto->producto->id_product = $idProducto;
            $tempIdiomas = explode('_', $this->file);
            $idIdioma = $tempIdiomas[0];

            $tempCategorias = array();
            $tempCategorias[] = $datos[16];
            $tempCategorias[] = $datos[18];
            if (trim(strtoupper($datos[4])) != trim(strtoupper($datos[18]))) {
                $tempCategorias[] = $datos[4];
            }
            $producto->producto->categoria = new stdClass();
            $equivalenciasCategorias = $this->buscarArbolCategorias($idProducto);
            $i = 0;
            if (count($tempCategorias) == count($equivalenciasCategorias)) {
                foreach ($tempCategorias AS $categoria) {
                    if ($producto->categoriaTraducida($equivalenciasCategorias[$i], $idIdioma)  === false) {
                        $producto->producto->categoria->{$idIdioma}[$equivalenciasCategorias[$i]] = array();
                        $temp = array();
                        $temp['name'] = $categoria;
                        $temp['link_rewrite'] = $categoria;
                        $temp['description'] = $categoria;
                        $temp['meta_title'] = $categoria;
                        $temp['meta_description'] = $categoria;
                        $temp['meta_keywords'] = $categoria;
                        $producto->producto->categoria->{$idIdioma}[$equivalenciasCategorias[$i]] = $temp;
                    }
                    $i++;
                }
            } else {
                Logger::addLog("Producto cambiado de categoria en el archivo: " . $idProducto, 4, 1010, 'Product', true);
            }
            $producto->producto->traducciones = new StdClass();
            $producto->producto->traducciones->{$idIdioma} = array();
            $producto->producto->idIdioma = $idIdioma;
            $nombre = explode('-', $datos[1]);
            if (isset($nombre[0])) {
                $nombre = trim($nombre[0]);
            } else {
                $nombre = mb_substr(trim($datos[1]), 0, 31);
            }
            $producto->producto->traducciones->{$idIdioma}['name'] = $nombre;
            $producto->producto->traducciones->{$idIdioma}['description'] = $datos[12];
            $producto->producto->traducciones->{$idIdioma}['description_short'] = mb_substr($datos[12], 0, 128) . '...';
            $producto->producto->traducciones->{$idIdioma}['link_rewrite'] = $nombre;
            $producto->producto->traducciones->{$idIdioma}['meta_title'] = $nombre;
            $producto->producto->traducciones->{$idIdioma}['meta_keywords'] = $nombre;
            $producto->producto->traducciones->{$idIdioma}['meta_description'] = $nombre;
            $producto->producto->traducciones->{$idIdioma}['available_now'] = '';
            if ($producto->producto->traducciones->{$idIdioma}['name'] != '') {
                if (!$producto->traducirProducto()) {
                    die('error 1');
                    unset($producto);
                    unset($datos);
                    unset($temp);
                    unset($nombre);
                    return false;
                }
            }

            $this->numElementosProcesados++;
            $producto->updateNumLineas($this->idImport, $this->tipo, $nombre . ':' . $producto->producto->traducciones->{$idIdioma}['name'], $this->numElementosProcesados, $this->orden);
            if ((int) $this->numElementosProcesados >= (int) ConfigurationCore::get($producto->sufijo . 'CANTIDAD_PROD')) {
                unset($producto);
                unset($datos);
                unset($temp);
                unset($nombre);
                $this->finalizadoBatch = 1;
                $this->closeCsvFile($this->fh);
                return true;
            }
            unset($producto);
            unset($datos);
            unset($temp);
        }
        if (!isset($datos) || !$datos) {
            $this->finalizadoBatch = 0;
            $this->closeCsvFile($this->fh);
            return true;
        }
    }

}

?>
